using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace SID_monitor
{
    public partial class SIDEventsViewer : UserControl
    {
        public static String[] TimeQualifierItems = new String[] { "None", "After (D)", "Before (E)", "Uncertain (U)" };
        public static String[] ImportanceItems = new String[] { "1- (< 19 mn)", "1 (19-25mn)", "1+ (26-32mn)", "2 (33-45mn)", "2+ (46-85mn)", "3 (86-125mn)", "3+ (>125mn)" };
        public static String[] DefinitenessItems = new String[] { "0 (Questionable)", "1 (Possible)", "2 (Fair)", "3 (Reasonable)", "4 (Reasonably Definite)", "5 (Definite)" };

        private bool enableContextMenu = true;  // indicates if the contextum menu is displayed or not

        public SIDEventsViewer()
        {
            InitializeComponent();

            this.ContextMenuStrip = this.contextMenuStripEvents;

            // initialize columns comboBoxes
            this.StartQual.Items.AddRange(TimeQualifierItems);
            this.EndQual.Items.AddRange(TimeQualifierItems);
            this.MaxQual.Items.AddRange(TimeQualifierItems);

            this.Importance.Items.AddRange(ImportanceItems);
            this.Definiteness.Items.AddRange(DefinitenessItems);

        }

        #region Public Methods
        public void ClearSelection()
        {
            this.dataGridViewSIDEvents.ClearSelection();
        }
        #endregion

        #region Properties
        public bool EnableContextMenu
        {
            get { return this.enableContextMenu; }
            set
            {
                this.enableContextMenu = value;
                if (this.enableContextMenu)
                {
                    this.ContextMenuStrip = this.contextMenuStripEvents;
                }
                else
                {
                    this.ContextMenuStrip = null;
                }
            }
        }

        public bool ReadOnly
        {
            get { return this.dataGridViewSIDEvents.ReadOnly; }
            set
            {
                this.dataGridViewSIDEvents.ReadOnly = value;
            }
        }

        public DataGridViewRowCollection Rows
        {
            get { return this.dataGridViewSIDEvents.Rows; }
        }


        public SIDEvents.DataTableEventsDataTable SIDEventsDataTable
        {
            get { return this.sidEvents.DataTableEvents; }
        }

        public bool RowHeadersVisible
        {
            get { return this.dataGridViewSIDEvents.RowHeadersVisible; }
            set
            {
                this.dataGridViewSIDEvents.RowHeadersVisible = value;
            }
        }

        public DataGridViewSelectionMode SelectionMode
        {
            get { return this.dataGridViewSIDEvents.SelectionMode; }
            set
            {
                this.dataGridViewSIDEvents.SelectionMode = value;
            }
        }

        public bool AllowUserToAddRows
        {
            get { return this.dataGridViewSIDEvents.AllowUserToAddRows; }
            set
            {
                this.dataGridViewSIDEvents.AllowUserToAddRows = value;
            }
        }

        public DataGridViewSelectedRowCollection SelectedRows
        {
            get { return this.dataGridViewSIDEvents.SelectedRows; }
        }
        #endregion

        #region datagrid validation methods
        private void dataGridViewSIDEvents_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            DataGridView view = (DataGridView)sender;
            switch (e.ColumnIndex)
            {
                case 0: // Date
                    view.Rows[e.RowIndex].ErrorText = "Enter a valid date";
                    break;
                case 1: // StartTime
                    view.Rows[e.RowIndex].ErrorText = "Enter a valid start time";
                    break;
                case 2: // StartQual
                    view.Rows[e.RowIndex].ErrorText = "Start Time Qualifier error";
                    break;
                case 3: // EndTime
                    view.Rows[e.RowIndex].ErrorText = "Enter a valid end time";
                    break;
                case 4: // EndQual
                    view.Rows[e.RowIndex].ErrorText = "End Time Qualifier error";
                    break;
                case 5: // MaxTime
                    view.Rows[e.RowIndex].ErrorText = "Enter a valid maximum time";
                    break;
                case 6: // MaxQual
                    view.Rows[e.RowIndex].ErrorText = "Maximum Time Qualifier error";
                    break;
                case 7: // Importance
                    view.Rows[e.RowIndex].ErrorText = "Importance error";
                    break;
                case 8: // Definiteness
                    view.Rows[e.RowIndex].ErrorText = "Definiteness error";
                    break;
                case 9: // StationCode
                    view.Rows[e.RowIndex].ErrorText = "Station Code error";
                    break;
                case 10: // ObserverCode
                    view.Rows[e.RowIndex].ErrorText = "Observer Code error";
                    break;
            }

            e.Cancel = true;
            e.ThrowException = false;

        }

        private void dataGridViewSIDEvents_CellValidated(object sender, DataGridViewCellEventArgs e)
        {
            DataGridView view = (DataGridView)sender;
            view.Rows[e.RowIndex].ErrorText = "";

        }
        #endregion

        #region ContextMenu Enabling Methods
        /// <summary>
        /// Enables Deleting Events only if some are selected
        /// </summary>
        private void contextMenuStripEvents_Opening(object sender, CancelEventArgs e)
        {
            if (this.dataGridViewSIDEvents.SelectedRows.Count > 0)
            {
                deleteEventToolStripMenuItem.Enabled = true;
            }
            else
            {
                deleteEventToolStripMenuItem.Enabled = false;
            }

            if (this.dataGridViewSIDEvents.SelectedRows.Count == 1)
            {
                editEventToolStripMenuItem.Enabled = true;
            }
            else
            {
                editEventToolStripMenuItem.Enabled = false;
            }
        }
        #endregion

        #region ContextMenu Buttons Handling
        private void addEventToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OnAddEventRequested(e);
        }

        private void editEventToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OnEditEventRequested(e);
        }

        private void deleteEventToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OnDeleteEventRequested(e);
        }
        #endregion

        #region Events

        /// <summary>
        /// DataModified Event
        /// </summary>

        public event EventHandler DataModified;  // dataGridView content has changed

        protected virtual void OnDataModified(EventArgs e)
        {
            EventHandler handler = DataModified;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// AddEventRequested Event
        /// </summary>

        public event EventHandler AddEventRequested;  // AddEvent is requested

        protected virtual void OnAddEventRequested(EventArgs e)
        {
            EventHandler handler = AddEventRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// EditEventRequested Event
        /// </summary>

        public event EventHandler EditEventRequested;  // EditEvent is requested

        protected virtual void OnEditEventRequested(EventArgs e)
        {
            EventHandler handler = EditEventRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// DeleteEventRequested Event
        /// </summary>

        public event EventHandler DeleteEventRequested;  // AddEvent is requested

        protected virtual void OnDeleteEventRequested(EventArgs e)
        {
            EventHandler handler = DeleteEventRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        public event EventHandler SelectionChanged;

        protected virtual void OnSelectionChanged(EventArgs e)
        {
            EventHandler handler = SelectionChanged;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }
        #endregion

        #region dataGridViewSIDEvents Events HAndling
        private void dataGridViewSIDEvents_SelectionChanged(object sender, EventArgs e)
        {
            OnSelectionChanged(e);
        }

        private void dataGridViewSIDEvents_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            OnEditEventRequested(e);
        }

        private void dataGridViewSIDEvents_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            OnDataModified(e);
        }

        private void dataGridViewSIDEvents_RowsAdded(object sender, DataGridViewRowsAddedEventArgs e)
        {
            OnDataModified(e);
        }

        private void dataGridViewSIDEvents_RowsRemoved(object sender, DataGridViewRowsRemovedEventArgs e)
        {
            OnDataModified(e);
        }
        #endregion

    }

}
